# University Admission Portal - cPanel Installation Guide

Follow these steps to deploy the Admission Portal to a cPanel hosting environment.

## Step 1: Export Your Local Database
Since you have made changes to the database structure (new tables, columns, etc.), you must export your current local database.
1. Open XAMPP Control Panel and ensure MySQL is running.
2. Open your browser and go to [http://localhost/phpmyadmin](http://localhost/phpmyadmin).
3. From the left sidebar, click on the **admission_system** database.
4. Click on the **Export** tab in the top menu.
5. Keep the default settings (Quick, SQL) and click **Go**.
6. A file named `admission_system.sql` will be downloaded. Keep this safe.

## Step 2: Prepare Project Files
1. Open your local project folder:
   - `C:\xampp\htdocs\admission_portal`
2. Select all files and folders inside this directory.
3. Right-click and select **Send to > Compressed (zipped) folder**.
4. Name the file `admission_portal.zip`.

## Step 3: Upload Files to cPanel
1. Log in to your cPanel account.
2. Open **File Manager**.
3. Navigate to the folder where you want to host the site:
   - For main domain: `public_html`
   - For subdomain: `public_html/your_subdomain`
4. Click the **Upload** button in the top toolbar.
5. Select and upload your `admission_portal.zip` file.
6. Once uploaded, right-click the zip file in File Manager and select **Extract**.
7. You can now delete the zip file.

## Step 4: Create Database on cPanel
1. Go back to the cPanel main dashboard.
2. Click on **MySQL Database Wizard**.
3. **Step 1:** Create a New Database (e.g., `youruser_admission`). Click Next.
4. **Step 2:** Create a Database User (e.g., `youruser_admin`) and a strong Password.
   - **Important:** Copy and save the Database Name, Username, and Password in a notepad. You will need them later.
5. **Step 3:** Check the box **ALL PRIVILEGES**. Click Next/Make Changes.

## Step 5: Import Database
1. Go to cPanel dashboard and click on **phpMyAdmin**.
2. In the left sidebar, click on the database you created in Step 4.
3. Click the **Import** tab.
4. Click **Choose File** and select the `admission_system.sql` file you downloaded in Step 1.
5. Click **Go** at the bottom.
6. You should see a success message: "Import has been successfully finished."

## Step 6: Configure Database Connection
1. Go back to **File Manager** in cPanel.
2. Navigate to your project folder (`includes/`).
3. Right-click on `db.php` and select **Edit**.
4. Update the database credentials with the ones you created in Step 4:

```php
<?php
$servername = "localhost";
$username = "youruser_admin";      // Your cPanel Database Username
$password = "your_password";       // Your cPanel Database Password
$dbname = "youruser_admission";    // Your cPanel Database Name

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
?>
```
5. Click **Save Changes**.

## Step 7: Verify Installation
1. Open your web browser and visit your website URL (e.g., `www.yourdomain.com`).
2. Log in with your admin credentials:
   - **Email:** `admin@uol.edu.pk`
   - **Password:** `admin123` (or whatever you changed it to locally).
3. Test the features:
   - Check if Reports load correctly.
   - Try registering a dummy student.
   - Check if Settings save correctly.

## Troubleshooting
- **White Screen / 500 Error:** Check your PHP version in cPanel "Select PHP Version". This project requires PHP 7.4 or higher (8.0+ recommended).
- **Database Error:** Double-check your username, password, and database name in `includes/db.php`. Ensure the user has "All Privileges".
- **404 Not Found:** Ensure all files were extracted correctly to the right folder.
