# University Admission Portal

A comprehensive web-based University Admission Management System developed in PHP.

## Features

### Student Portal
- **User Registration & Login:** Secure account creation and authentication.
- **Program Selection:** Browse and select available degree programs.
- **Application Process:** Step-by-step application form:
  1. Personal Information
  2. Academic Records
  3. Document Uploads
  4. Review & Submit
- **Dashboard:** Track application status (Submitted, Under Review, Accepted, Rejected).
- **Profile Management:** Update contact information and password.

### Admin Portal
- **Dashboard:** Overview of total applications and status statistics.
- **Application Management:** Review applications, view documents, and update application status (Accept/Reject).
- **Program Management:** Add new programs, deactivate existing ones, and manage fees/details.
- **Student List:** View registered students.

## Setup Instructions

### 1. Database Setup
1. Open your database management tool (e.g., phpMyAdmin).
2. Create a new database named `admission_system`.
3. Import the `database.sql` file located in the root directory of this project.

### 2. Configuration
1. Open `includes/db.php`.
2. Update the database credentials if necessary (Default: root, no password).

### 3. Admin Account Setup
1. To create the default admin account, navigate to:
   `http://localhost/admission_portal/admin/seed_admin.php`
2. This will create a user with:
   - **Email:** admin@uol.edu.pk
   - **Password:** admin123
3. **Important:** Delete `admin/seed_admin.php` after creating the admin account for security.

### 4. Running the Project
1. Place the `admission_portal` folder in your server's root directory (e.g., `htdocs` for XAMPP).
2. Start Apache and MySQL.
3. Access the portal at: `http://localhost/admission_portal/`

## Credits

**Developed By:** BM Host UK  
**Website:** [www.bmhost.co.uk](http://www.bmhost.co.uk)
