<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'system_admin'])) {
    header("Location: login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Portal - University Admission System</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <!-- FontAwesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .admin-sidebar {
            background-color: #263238;
            color: #fff;
        }
        .admin-sidebar .sidebar-menu li a {
            color: #b0bec5;
        }
        .admin-sidebar .sidebar-menu li a:hover, .admin-sidebar .sidebar-menu li a.active {
            background-color: #37474f;
            color: #fff;
            border-left-color: #00bcd4;
        }
        .admin-header {
            background-color: #263238;
            color: #fff;
        }
        .admin-header .logo a {
            color: #fff;
        }
    </style>
</head>
<body>
    <header class="admin-header">
        <div class="container navbar">
            <div class="logo">
                <a href="index.php">
                    <i class="fas fa-user-shield fa-lg" style="margin-right: 10px;"></i>
                    Admin Portal
                </a>
            </div>
            <ul class="nav-links">
                <li><a href="../index.php" target="_blank" style="color: #fff;">Visit Site</a></li>
                <li><a href="logout.php" class="btn-outline" style="border-color: #fff; color: #fff !important;">Logout</a></li>
            </ul>
        </div>
    </header>
