<?php
include '../includes/db.php';
include 'includes/header.php';

// Fetch Statistics
$total_apps = $conn->query("SELECT COUNT(*) as count FROM applications")->fetch_assoc()['count'];
$submitted = $conn->query("SELECT COUNT(*) as count FROM applications WHERE status='Submitted'")->fetch_assoc()['count'];
$accepted = $conn->query("SELECT COUNT(*) as count FROM applications WHERE status='Accepted'")->fetch_assoc()['count'];
$rejected = $conn->query("SELECT COUNT(*) as count FROM applications WHERE status='Rejected'")->fetch_assoc()['count'];

// Fetch Recent Applications
$sql = "SELECT a.id, u.full_name, p.program_name, a.status, a.submission_date 
        FROM applications a 
        JOIN users u ON a.user_id = u.id 
        JOIN programs p ON a.program_id = p.id 
        ORDER BY a.submission_date DESC";
$result = $conn->query($sql);
?>

<div class="dashboard-container">
    <div class="sidebar admin-sidebar">
        <?php include 'includes/sidebar.php'; ?>
    </div>

    <div class="main-content">
        <h2 style="margin-bottom: 25px;">Admin Dashboard</h2>

        <div style="display: flex; gap: 20px; flex-wrap: wrap; margin-bottom: 30px;">
            <div class="card" style="flex: 1; min-width: 200px; text-align: center; border-left: 5px solid #0288d1;">
                <h3 style="font-size: 2.5rem; margin: 10px 0; color: #0288d1;"><?php echo $total_apps; ?></h3>
                <p>Total Applications</p>
            </div>
            <div class="card" style="flex: 1; min-width: 200px; text-align: center; border-left: 5px solid #fbc02d;">
                <h3 style="font-size: 2.5rem; margin: 10px 0; color: #fbc02d;"><?php echo $submitted; ?></h3>
                <p>Pending Review</p>
            </div>
            <div class="card" style="flex: 1; min-width: 200px; text-align: center; border-left: 5px solid #388e3c;">
                <h3 style="font-size: 2.5rem; margin: 10px 0; color: #388e3c;"><?php echo $accepted; ?></h3>
                <p>Accepted</p>
            </div>
            <div class="card" style="flex: 1; min-width: 200px; text-align: center; border-left: 5px solid #d32f2f;">
                <h3 style="font-size: 2.5rem; margin: 10px 0; color: #d32f2f;"><?php echo $rejected; ?></h3>
                <p>Rejected</p>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Recent Applications</h3>
            </div>
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Student Name</th>
                        <th>Program</th>
                        <th>Date</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result->num_rows > 0): ?>
                        <?php while($row = $result->fetch_assoc()): 
                             $status_class = 'badge-warning';
                             if($row['status'] == 'Submitted') $status_class = 'badge-info';
                             if($row['status'] == 'Accepted') $status_class = 'badge-success';
                             if($row['status'] == 'Rejected') $status_class = 'badge-danger';
                        ?>
                        <tr>
                            <td>#<?php echo $row['id']; ?></td>
                            <td><?php echo $row['full_name']; ?></td>
                            <td><?php echo $row['program_name']; ?></td>
                            <td><?php echo $row['submission_date'] ? date('d M, Y', strtotime($row['submission_date'])) : 'Draft'; ?></td>
                            <td><span class="badge <?php echo $status_class; ?>"><?php echo $row['status']; ?></span></td>
                            <td>
                                <a href="view_application.php?id=<?php echo $row['id']; ?>" class="btn-primary" style="padding: 5px 10px; font-size: 0.8rem; text-decoration: none;">Review</a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center">No applications found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
