<?php 
session_start();
include '../includes/db.php';

if (isset($_SESSION['user_id']) && in_array($_SESSION['role'], ['admin', 'system_admin'])) {
    header("Location: index.php");
    exit();
}

$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $conn->real_escape_string($_POST['email']);
    $password = $_POST['password'];

    // Debug: Show what we're looking for
    $debug_sql = "SELECT id, full_name, password, role FROM users WHERE email = '$email' AND role IN ('admin', 'system_admin')";
    $result = $conn->query($debug_sql);
    
    // Debug: Show query results
    if ($result->num_rows == 0) {
        $error = "No admin account found with email: $email";
        // Debug: Check if user exists at all
        $check_any = $conn->query("SELECT email, role FROM users WHERE email = '$email'");
        if ($check_any->num_rows > 0) {
            $user_info = $check_any->fetch_assoc();
            $error .= " (User exists with role: " . $user_info['role'] . ")";
        }
    } elseif ($result->num_rows == 1) {
        $row = $result->fetch_assoc();
        if (password_verify($password, $row['password'])) {
            $_SESSION['user_id'] = $row['id'];
            $_SESSION['full_name'] = $row['full_name'];
            $_SESSION['role'] = $row['role'];
            $_SESSION['email'] = $email; // Add email to session
            header("Location: index.php");
            exit();
        } else {
            $error = "Invalid password for user: " . $row['full_name'];
        }
    } else {
        $error = "Multiple admin accounts found with email: $email";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - University Admission Portal</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #263238; }
        .auth-box { margin-top: 50px; }
    </style>
</head>
<body>
    <div class="auth-wrapper">
        <div class="auth-box">
            <h2 style="color: #263238;"><i class="fas fa-user-shield"></i> Admin Login</h2>
            <?php if($error): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label>Email Address</label>
                    <input type="email" name="email" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Password</label>
                    <input type="password" name="password" class="form-control" required>
                    <div style="text-align: right; margin-top: 5px;">
                        <a href="../forgot_password.php" style="font-size: 0.9rem; color: #bbb;">Forgot Password?</a>
                    </div>
                </div>
                <button type="submit" class="btn-primary btn-block" style="background-color: #263238;">Login to Dashboard</button>
            </form>
            <p class="text-center" style="margin-top: 15px;">
                <a href="../index.php" style="color: #666;">&larr; Back to Main Site</a>
            </p>
        </div>
    </div>
</body>
</html>
