<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'system_admin', 'super_admin'])) {
    header("Location: login.php");
    exit();
}

include '../includes/db.php';
include 'includes/header.php';

// Handle filters
$filter_status = $_GET['filter_status'] ?? '';
$filter_program = $_GET['filter_program'] ?? '';
$filter_date_from = $_GET['filter_date_from'] ?? '';
$filter_date_to = $_GET['filter_date_to'] ?? '';

// Build query with filters
$where_clause = "WHERE 1=1";
if (!empty($filter_status)) {
    $where_clause .= " AND a.status = '$filter_status'";
}
if (!empty($filter_program)) {
    $where_clause .= " AND p.program_name LIKE '%$filter_program%'";
}
if (!empty($filter_date_from)) {
    $where_clause .= " AND DATE(a.submission_date) >= '$filter_date_from'";
}
if (!empty($filter_date_to)) {
    $where_clause .= " AND DATE(a.submission_date) <= '$filter_date_to'";
}

// Get all applications with student and program details
$applications_sql = "SELECT a.*, u.full_name, u.email, p.program_name 
                   FROM applications a
                   JOIN users u ON a.user_id = u.id
                   JOIN programs p ON a.program_id = p.id
                   $where_clause
                   ORDER BY a.submission_date DESC";
$applications_result = $conn->query($applications_sql);

// Get unique programs for filter
$programs_sql = "SELECT DISTINCT p.program_name 
                FROM programs p
                JOIN applications a ON p.id = a.program_id
                ORDER BY p.program_name";
$programs_result = $conn->query($programs_sql);
?>

<div class="dashboard-container">
    <div class="sidebar admin-sidebar">
        <?php include 'includes/sidebar.php'; ?>
    </div>

    <div class="main-content">
        <h2>Manage Applications</h2>
        
        <!-- Filters Section -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Filter Applications</h3>
            </div>
            <div class="card-body">
                <form method="GET" action="">
                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr 1fr auto; gap: 15px; align-items: end;">
                        <div class="form-group">
                            <label>Status</label>
                            <select name="filter_status" class="form-control">
                                <option value="">All Status</option>
                                <option value="Submitted" <?php echo ($filter_status == 'Submitted') ? 'selected' : ''; ?>>Submitted</option>
                                <option value="Under Review" <?php echo ($filter_status == 'Under Review') ? 'selected' : ''; ?>>Under Review</option>
                                <option value="Approved" <?php echo ($filter_status == 'Approved') ? 'selected' : ''; ?>>Approved</option>
                                <option value="Rejected" <?php echo ($filter_status == 'Rejected') ? 'selected' : ''; ?>>Rejected</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Program</label>
                            <select name="filter_program" class="form-control">
                                <option value="">All Programs</option>
                                <?php while($program = $programs_result->fetch_assoc()): ?>
                                    <option value="<?php echo $program['program_name']; ?>" 
                                            <?php echo ($filter_program == $program['program_name']) ? 'selected' : ''; ?>>
                                        <?php echo $program['program_name']; ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Date From</label>
                            <input type="date" name="filter_date_from" class="form-control" value="<?php echo $filter_date_from; ?>">
                        </div>
                        <div class="form-group">
                            <label>Date To</label>
                            <input type="date" name="filter_date_to" class="form-control" value="<?php echo $filter_date_to; ?>">
                        </div>
                        <button type="submit" class="btn-primary">Apply Filters</button>
                    </div>
                    <?php if($filter_status || $filter_program || $filter_date_from || $filter_date_to): ?>
                        <div style="margin-top: 10px;">
                            <a href="manage_applications.php" class="btn-outline">Clear Filters</a>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">All Applications</h3>
            </div>
            <div class="card-body">
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Student Name</th>
                            <th>Email</th>
                            <th>Program</th>
                            <th>Status</th>
                            <th>Submission Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($applications_result->num_rows > 0): ?>
                            <?php while($application = $applications_result->fetch_assoc()): ?>
                                <tr>
                                    <td>#<?php echo $application['id']; ?></td>
                                    <td><?php echo $application['full_name']; ?></td>
                                    <td><?php echo $application['email']; ?></td>
                                    <td><?php echo $application['program_name']; ?></td>
                                    <td>
                                        <?php
                                        $status_class = '';
                                        switch($application['status']) {
                                            case 'Submitted':
                                                $status_class = 'badge-info';
                                                break;
                                            case 'Under Review':
                                                $status_class = 'badge-warning';
                                                break;
                                            case 'Approved':
                                                $status_class = 'badge-success';
                                                break;
                                            case 'Rejected':
                                                $status_class = 'badge-danger';
                                                break;
                                        }
                                        ?>
                                        <span class="badge <?php echo $status_class; ?>">
                                            <?php echo $application['status']; ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('d M, Y H:i', strtotime($application['submission_date'])); ?></td>
                                    <td>
                                        <a href="view_application.php?id=<?php echo $application['id']; ?>" class="btn-primary" style="padding: 5px 10px; font-size: 0.9rem;">View Details</a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" style="text-align: center;">No applications found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
