<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'system_admin', 'super_admin'])) {
    header("Location: login.php");
    exit();
}

include '../includes/db.php';
include 'includes/header.php';

// Handle filters
$filter_name = $_GET['filter_name'] ?? '';
$filter_email = $_GET['filter_email'] ?? '';
$filter_date_from = $_GET['filter_date_from'] ?? '';
$filter_date_to = $_GET['filter_date_to'] ?? '';

// Build query with filters
$where_clause = "WHERE role = 'student'";
if (!empty($filter_name)) {
    $where_clause .= " AND full_name LIKE '%$filter_name%'";
}
if (!empty($filter_email)) {
    $where_clause .= " AND email LIKE '%$filter_email%'";
}
if (!empty($filter_date_from)) {
    $where_clause .= " AND DATE(created_at) >= '$filter_date_from'";
}
if (!empty($filter_date_to)) {
    $where_clause .= " AND DATE(created_at) <= '$filter_date_to'";
}

// Get all students
$students_sql = "SELECT * FROM users $where_clause ORDER BY created_at DESC";
$students_result = $conn->query($students_sql);
?>

<div class="dashboard-container">
    <div class="sidebar admin-sidebar">
        <?php include 'includes/sidebar.php'; ?>
    </div>

    <div class="main-content">
        <h2>Manage Students</h2>
        
        <!-- Filters Section -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Filter Students</h3>
            </div>
            <div class="card-body">
                <form method="GET" action="">
                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr 1fr auto; gap: 15px; align-items: end;">
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" name="filter_name" class="form-control" placeholder="Search name..." value="<?php echo $filter_name; ?>">
                        </div>
                        <div class="form-group">
                            <label>Email</label>
                            <input type="text" name="filter_email" class="form-control" placeholder="Search email..." value="<?php echo $filter_email; ?>">
                        </div>
                        <div class="form-group">
                            <label>Registered From</label>
                            <input type="date" name="filter_date_from" class="form-control" value="<?php echo $filter_date_from; ?>">
                        </div>
                        <div class="form-group">
                            <label>Registered To</label>
                            <input type="date" name="filter_date_to" class="form-control" value="<?php echo $filter_date_to; ?>">
                        </div>
                        <button type="submit" class="btn-primary">Apply Filters</button>
                    </div>
                    <?php if($filter_name || $filter_email || $filter_date_from || $filter_date_to): ?>
                        <div style="margin-top: 10px;">
                            <a href="manage_students.php" class="btn-outline">Clear Filters</a>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">All Students</h3>
            </div>
            <div class="card-body">
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>CNIC</th>
                            <th>Phone</th>
                            <th>Registered At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($students_result->num_rows > 0): ?>
                            <?php while($student = $students_result->fetch_assoc()): ?>
                                <tr>
                                    <td>#<?php echo $student['id']; ?></td>
                                    <td><?php echo $student['full_name']; ?></td>
                                    <td><?php echo $student['email']; ?></td>
                                    <td><?php echo $student['cnic']; ?></td>
                                    <td><?php echo $student['phone']; ?></td>
                                    <td><?php echo date('d M, Y', strtotime($student['created_at'])); ?></td>
                                    <td>
                                        <a href="view_student_applications.php?id=<?php echo $student['id']; ?>" class="btn-primary" style="padding: 5px 10px; font-size: 0.9rem;">View Applications</a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" style="text-align: center;">No students found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
