<?php
include '../includes/db.php';
include 'includes/header.php';

// Initialize variables
$academic_year = isset($_GET['academic_year']) ? $_GET['academic_year'] : date('Y');
$session = isset($_GET['session']) ? $_GET['session'] : 'Fall';
$program_id = isset($_GET['program_id']) ? $_GET['program_id'] : '';

// Build Query
$where_clauses = ["a.status = 'Accepted'"]; // Merit list usually for accepted or potential students
if ($academic_year) {
    $where_clauses[] = "a.academic_year = '$academic_year'";
}
if ($session) {
    $where_clauses[] = "a.session = '$session'";
}
if ($program_id) {
    $where_clauses[] = "a.program_id = $program_id";
}

$where_sql = "WHERE " . implode(' AND ', $where_clauses);

$sql = "SELECT a.*, u.full_name, u.cnic, p.program_name 
        FROM applications a 
        JOIN users u ON a.user_id = u.id 
        JOIN programs p ON a.program_id = p.id 
        $where_sql 
        ORDER BY p.program_name, u.full_name";

$result = $conn->query($sql);

// Fetch Programs for Filter
$prog_sql = "SELECT * FROM programs";
$prog_res = $conn->query($prog_sql);
?>

<div class="dashboard-container">
    <div class="sidebar admin-sidebar">
        <?php include 'includes/sidebar.php'; ?>
    </div>

    <div class="main-content">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Merit List Generation</h3>
                <button onclick="window.print()" class="btn-primary" style="padding: 5px 15px; font-size: 0.9rem;"><i class="fas fa-print"></i> Print List</button>
            </div>

            <form method="GET" action="" style="background: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 20px;">
                <div style="display: flex; gap: 15px; flex-wrap: wrap; align-items: flex-end;">
                    <div class="form-group" style="margin-bottom: 0; flex: 1; min-width: 150px;">
                        <label>Academic Year</label>
                        <select name="academic_year" class="form-control">
                            <?php 
                            $current_year = date('Y');
                            for($i=$current_year; $i>=$current_year-5; $i--) {
                                $selected = ($academic_year == $i) ? 'selected' : '';
                                echo "<option value='$i' $selected>$i</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="form-group" style="margin-bottom: 0; flex: 1; min-width: 150px;">
                        <label>Session</label>
                        <select name="session" class="form-control">
                            <option value="Fall" <?php if($session == 'Fall') echo 'selected'; ?>>Fall</option>
                            <option value="Spring" <?php if($session == 'Spring') echo 'selected'; ?>>Spring</option>
                        </select>
                    </div>
                    <div class="form-group" style="margin-bottom: 0; flex: 1; min-width: 200px;">
                        <label>Program</label>
                        <select name="program_id" class="form-control">
                            <option value="">-- All Programs --</option>
                            <?php while($p = $prog_res->fetch_assoc()): ?>
                                <option value="<?php echo $p['id']; ?>" <?php if($program_id == $p['id']) echo 'selected'; ?>><?php echo $p['program_name']; ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    <div class="form-group" style="margin-bottom: 0;">
                        <button type="submit" class="btn-primary" style="padding: 10px 20px;"><i class="fas fa-list-ol"></i> Generate List</button>
                    </div>
                </div>
            </form>

            <div style="overflow-x: auto;">
                <?php if ($result->num_rows > 0): ?>
                    <div class="alert alert-info" style="margin-bottom: 20px;">
                        Showing Merit List for <strong><?php echo $session . ' ' . $academic_year; ?></strong>
                    </div>
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Position</th>
                                <th>Student Name</th>
                                <th>CNIC</th>
                                <th>Program</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $count = 1;
                            while($row = $result->fetch_assoc()): 
                            ?>
                            <tr>
                                <td><?php echo $count++; ?></td>
                                <td><?php echo $row['full_name']; ?></td>
                                <td><?php echo $row['cnic']; ?></td>
                                <td><?php echo $row['program_name']; ?></td>
                                <td><span class="badge badge-success"><?php echo $row['status']; ?></span></td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="alert alert-warning text-center">
                        No accepted applications found for <strong><?php echo $session . ' ' . $academic_year; ?></strong>.
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
