<?php
include '../includes/db.php';
include 'includes/header.php';

$message = "";

// Only admin@uol.edu.pk can access settings
if ($_SESSION['email'] !== 'admin@uol.edu.pk') {
    header("Location: index.php");
    exit();
}

// Handle Reset Data
if (isset($_POST['reset_data'])) {
    $reset_type = $_POST['reset_type'];
    
    if ($reset_type == 'all') {
        $conn->query("SET FOREIGN_KEY_CHECKS = 0");
        $conn->query("TRUNCATE TABLE applications");
        $conn->query("TRUNCATE TABLE academic_records");
        $conn->query("TRUNCATE TABLE personal_details");
        $conn->query("TRUNCATE TABLE documents");
        $conn->query("DELETE FROM users WHERE role != 'admin'");
        $conn->query("SET FOREIGN_KEY_CHECKS = 1");
        $message = "All student data has been reset successfully.";
    } elseif ($reset_type == 'portal') {
        $conn->query("SET FOREIGN_KEY_CHECKS = 0");
        $conn->query("TRUNCATE TABLE applications");
        $conn->query("TRUNCATE TABLE academic_records");
        $conn->query("TRUNCATE TABLE personal_details");
        $conn->query("TRUNCATE TABLE documents");
        $conn->query("DELETE FROM users WHERE role = 'student'");
        $conn->query("SET FOREIGN_KEY_CHECKS = 1");
        $message = "Portal data (students and applications) has been reset successfully.";
    } elseif ($reset_type == 'vouchers') {
        $conn->query("TRUNCATE TABLE voucher_codes");
        $message = "All voucher data has been deleted successfully.";
    }
}

// Handle Status Update
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['registration_status'])) {
        $status = $_POST['registration_status']; // 'open' or 'closed'
        
        // Update or Insert setting
        $sql = "INSERT INTO system_settings (setting_key, setting_value) 
                VALUES ('registration_status', '$status') 
                ON DUPLICATE KEY UPDATE setting_value = '$status'";
                
        if ($conn->query($sql) === TRUE) {
            $message = "Registration status updated to <strong>" . strtoupper($status) . "</strong> successfully!";
        } else {
            $message = "Error updating settings: " . $conn->error;
        }
    }
    
    if (isset($_POST['current_session'])) {
        $session = $_POST['current_session'];
        
        // Update or Insert setting
        $sql = "INSERT INTO system_settings (setting_key, setting_value) 
                VALUES ('current_session', '$session') 
                ON DUPLICATE KEY UPDATE setting_value = '$session'";
                
        if ($conn->query($sql) === TRUE) {
            $message = "Session updated to <strong>$session</strong> successfully!";
        } else {
            $message = "Error updating session: " . $conn->error;
        }
    }
    
    if (isset($_POST['current_academic_year'])) {
        $academic_year = $_POST['current_academic_year'];
        
        // Update or Insert setting
        $sql = "INSERT INTO system_settings (setting_key, setting_value) 
                VALUES ('current_academic_year', '$academic_year') 
                ON DUPLICATE KEY UPDATE setting_value = '$academic_year'";
                
        if ($conn->query($sql) === TRUE) {
            $message = "Academic Year updated to <strong>$academic_year</strong> successfully!";
        } else {
            $message = "Error updating academic year: " . $conn->error;
        }
    }
}

// Fetch Current Settings
$current_status = 'open';
$current_session = 'Fall';
$current_academic_year = date('Y');

$res = $conn->query("SELECT setting_key, setting_value FROM system_settings");
if ($res->num_rows > 0) {
    while($row = $res->fetch_assoc()) {
        if($row['setting_key'] == 'registration_status') $current_status = $row['setting_value'];
        if($row['setting_key'] == 'current_session') $current_session = $row['setting_value'];
        if($row['setting_key'] == 'current_academic_year') $current_academic_year = $row['setting_value'];
    }
}
?>

<div class="dashboard-container">
    <div class="sidebar admin-sidebar">
        <?php include 'includes/sidebar.php'; ?>
    </div>

    <div class="main-content">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">System Settings</h3>
            </div>

            <?php if($message): ?>
                <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>

            <div style="padding: 20px;">
                <h4 style="margin-top: 0; border-bottom: 1px solid #eee; padding-bottom: 10px; margin-bottom: 20px;">
                    Student Registration
                </h4>
                
                <form method="POST" action="">
                    <div class="form-group">
                        <label style="display: block; margin-bottom: 10px; font-weight: bold;">Admissions Status:</label>
                        
                        <div style="display: flex; gap: 20px; margin-bottom: 20px;">
                            <label style="cursor: pointer; display: flex; align-items: center;">
                                <input type="radio" name="registration_status" value="open" <?php if($current_status == 'open') echo 'checked'; ?> style="margin-right: 8px;">
                                <span class="badge badge-success" style="font-size: 1rem; padding: 5px 15px;">Open</span>
                            </label>
                            
                            <label style="cursor: pointer; display: flex; align-items: center;">
                                <input type="radio" name="registration_status" value="closed" <?php if($current_status == 'closed') echo 'checked'; ?> style="margin-right: 8px;">
                                <span class="badge badge-danger" style="font-size: 1rem; padding: 5px 15px;">Closed</span>
                            </label>
                        </div>
                        
                        <p style="color: #666; font-size: 0.9rem; margin-bottom: 20px;">
                            When <strong>Closed</strong>, new students will not be able to register accounts on the portal. Existing students can still log in.
                        </p>
                    </div>
                    
                    <div style="display: flex; gap: 20px; flex-wrap: wrap;">
                        <div class="form-group" style="flex: 1;">
                            <label>Current Session</label>
                            <select name="current_session" class="form-control">
                                <option value="Fall" <?php if($current_session == 'Fall') echo 'selected'; ?>>Fall</option>
                                <option value="Spring" <?php if($current_session == 'Spring') echo 'selected'; ?>>Spring</option>
                            </select>
                        </div>
                        <div class="form-group" style="flex: 1;">
                            <label>Current Academic Year</label>
                            <select name="current_academic_year" class="form-control">
                                <?php 
                                $cur_year = date('Y');
                                for($i=$cur_year; $i<=$cur_year+2; $i++) {
                                    $selected = ($current_academic_year == $i) ? 'selected' : '';
                                    echo "<option value='$i' $selected>$i</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>

                    <button type="submit" class="btn-primary" style="padding: 10px 25px;">Save Settings</button>
                </form>
            </div>

            <div style="margin-top: 20px; border-top: 1px solid #ddd; padding: 20px;">
                <h4 style="color: #d32f2f; margin-top: 0;">Danger Zone</h4>
                <div style="border: 1px solid #ffcdd2; background: #ffebee; padding: 20px; border-radius: 4px;">
                    <h5 style="margin-top: 0; color: #b71c1c;">Reset Portal Data</h5>
                    <p>Choose what data to reset:</p>
                    
                    <form method="POST" action="" onsubmit="return confirm('WARNING: This will permanently delete selected data. This action cannot be undone. Are you sure?');">
                        <input type="hidden" name="reset_data" value="1">
                        
                        <div style="margin-bottom: 20px;">
                            <label style="cursor: pointer; display: flex; align-items: center; margin-bottom: 10px;">
                                <input type="radio" name="reset_type" value="portal" checked style="margin-right: 10px;">
                                <div>
                                    <strong>Reset Portal Data Only</strong><br>
                                    <small style="color: #666;">Deletes all students, applications, documents, and records. Admin accounts and programs remain.</small>
                                </div>
                            </label>
                            
                            <label style="cursor: pointer; display: flex; align-items: center; margin-bottom: 10px;">
                                <input type="radio" name="reset_type" value="vouchers" style="margin-right: 10px;">
                                <div>
                                    <strong>Delete Voucher Data Only</strong><br>
                                    <small style="color: #666;">Deletes all voucher codes. Other data remains intact.</small>
                                </div>
                            </label>
                            
                            <label style="cursor: pointer; display: flex; align-items: center;">
                                <input type="radio" name="reset_type" value="all" style="margin-right: 10px;">
                                <div>
                                    <strong>Reset All Data</strong><br>
                                    <small style="color: #666;">Deletes all students, applications, documents, records, and non-admin users.</small>
                                </div>
                            </label>
                        </div>
                        
                        <button type="submit" class="btn-danger" style="background: #d32f2f; color: white; border: none; padding: 10px 20px; cursor: pointer; border-radius: 4px;">
                            <i class="fas fa-trash-alt"></i> Reset Selected Data
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
