<?php
include '../includes/db.php';
include 'includes/header.php';
include 'includes/excel_export.php';

// Fetch Users
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : '';

$where_clause = "WHERE role = 'student'";
if ($start_date) {
    $where_clause .= " AND DATE(created_at) >= '$start_date'";
}
if ($end_date) {
    $where_clause .= " AND DATE(created_at) <= '$end_date'";
}

$sql = "SELECT * FROM users $where_clause ORDER BY created_at DESC";
$result = $conn->query($sql);
$total_students = $result->num_rows;

// Handle Excel Export
if (isset($_GET['export']) && $_GET['export'] == 'excel') {
    $export_data = [];
    $headers = ['Student ID', 'Full Name', 'Email', 'Phone', 'CNIC', 'Session', 'Academic Year', 'Registration Date'];
    
    if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $export_data[] = [
                $row['id'],
                cleanForExcel($row['full_name']),
                cleanForExcel($row['email']),
                cleanForExcel($row['phone']),
                cleanForExcel($row['cnic']),
                cleanForExcel($row['session']),
                cleanForExcel($row['academic_year']),
                formatDateTime($row['created_at'])
            ];
        }
    }
    
    // Reset result pointer for normal display
    $result->data_seek(0);
    
    $filename = 'Registered_Students_' . date('Y-m-d_H-i-s') . '.xls';
    exportToExcel($export_data, $filename, $headers);
}
?>

<div class="dashboard-container">
    <div class="sidebar admin-sidebar">
        <?php include 'includes/sidebar.php'; ?>
    </div>

    <div class="main-content">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Registered Students</h3>
                <div style="display: flex; gap: 10px; align-items: center;">
                    <a href="?export=excel<?php echo !empty($_GET) ? '&' . http_build_query($_GET) : ''; ?>" class="btn-success" style="padding: 5px 15px; font-size: 0.9rem; text-decoration: none; color: white;"><i class="fas fa-file-excel"></i> Export to Excel</a>
                    <span class="badge badge-primary" style="font-size: 1rem;">Total Students: <?php echo $total_students; ?></span>
                </div>
            </div>

            <form method="GET" action="" style="background: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #ddd;">
                <div style="display: flex; gap: 15px; flex-wrap: wrap; align-items: flex-end;">
                    <div class="form-group" style="margin-bottom: 0;">
                        <label>Start Date</label>
                        <input type="date" name="start_date" class="form-control" value="<?php echo $start_date; ?>">
                    </div>
                    <div class="form-group" style="margin-bottom: 0;">
                        <label>End Date</label>
                        <input type="date" name="end_date" class="form-control" value="<?php echo $end_date; ?>">
                    </div>
                    <div class="form-group" style="margin-bottom: 0;">
                        <button type="submit" class="btn-primary" style="padding: 10px 20px;"><i class="fas fa-filter"></i> Filter</button>
                        <a href="users.php" class="btn-outline" style="padding: 10px 15px; text-decoration: none;">Reset</a>
                    </div>
                </div>
            </form>

            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>CNIC</th>
                        <th>Phone</th>
                        <th>Registered At</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result->num_rows > 0): ?>
                        <?php while($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td>#<?php echo $row['id']; ?></td>
                            <td><?php echo $row['full_name']; ?></td>
                            <td><?php echo $row['email']; ?></td>
                            <td><?php echo $row['cnic']; ?></td>
                            <td><?php echo $row['phone']; ?></td>
                            <td><?php echo date('d M, Y', strtotime($row['created_at'])); ?></td>
                        </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center">No students registered yet.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
