<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'system_admin', 'super_admin'])) {
    header("Location: login.php");
    exit();
}

include '../includes/db.php';
include 'includes/header.php';

if (!isset($_GET['id'])) {
    header("Location: manage_students.php");
    exit();
}

$student_id = intval($_GET['id']);

// Get student information
$student_sql = "SELECT * FROM users WHERE id = $student_id AND role = 'student'";
$student_result = $conn->query($student_sql);
$student = $student_result->fetch_assoc();

if (!$student) {
    header("Location: manage_students.php");
    exit();
}

// Get student's applications
$applications_sql = "SELECT a.*, p.program_name 
                   FROM applications a
                   JOIN programs p ON a.program_id = p.id
                   WHERE a.user_id = $student_id
                   ORDER BY a.submission_date DESC";
$applications_result = $conn->query($applications_sql);
?>

<div class="dashboard-container">
    <div class="sidebar admin-sidebar">
        <?php include 'includes/sidebar.php'; ?>
    </div>

    <div class="main-content">
        <h2>Student Applications</h2>
        
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Student Information</h3>
            </div>
            <div class="card-body">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    <div>
                        <strong>Name:</strong> <?php echo $student['full_name']; ?><br>
                        <strong>Email:</strong> <?php echo $student['email']; ?><br>
                        <strong>CNIC:</strong> <?php echo $student['cnic']; ?><br>
                        <strong>Phone:</strong> <?php echo $student['phone']; ?>
                    </div>
                    <div>
                        <strong>Registered:</strong> <?php echo date('d M, Y', strtotime($student['created_at'])); ?><br>
                        <strong>Student ID:</strong> #<?php echo $student['id']; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Application History</h3>
            </div>
            <div class="card-body">
                <?php if($applications_result->num_rows > 0): ?>
                    <table>
                        <thead>
                            <tr>
                                <th>Application ID</th>
                                <th>Program</th>
                                <th>Status</th>
                                <th>Submission Date</th>
                                <th>Voucher Code</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($application = $applications_result->fetch_assoc()): ?>
                                <tr>
                                    <td>#<?php echo $application['id']; ?></td>
                                    <td><?php echo $application['program_name']; ?></td>
                                    <td>
                                        <?php
                                        $status_class = '';
                                        switch($application['status']) {
                                            case 'Submitted':
                                                $status_class = 'badge-info';
                                                break;
                                            case 'Under Review':
                                                $status_class = 'badge-warning';
                                                break;
                                            case 'Approved':
                                                $status_class = 'badge-success';
                                                break;
                                            case 'Rejected':
                                                $status_class = 'badge-danger';
                                                break;
                                        }
                                        ?>
                                        <span class="badge <?php echo $status_class; ?>">
                                            <?php echo $application['status']; ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('d M, Y H:i', strtotime($application['submission_date'])); ?></td>
                                    <td>
                                        <code><?php echo $application['voucher_code'] ?? 'N/A'; ?></code>
                                    </td>
                                    <td>
                                        <a href="view_application.php?id=<?php echo $application['id']; ?>" 
                                           class="btn-primary" style="padding: 5px 10px; font-size: 0.9rem;">View Details</a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p>No applications found for this student.</p>
                <?php endif; ?>
            </div>
        </div>
        
        <div style="margin-top: 20px;">
            <a href="manage_students.php" class="btn-outline">← Back to Students</a>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
