<?php
include 'includes/db.php';
include 'includes/header.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$message = "";

// Check if user has existing personal details
$sql_details = "SELECT * FROM personal_details WHERE user_id = $user_id";
$result_details = $conn->query($sql_details);
$details = $result_details->fetch_assoc();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $program_id = $_POST['program_id'];
    $father_name = $conn->real_escape_string($_POST['father_name']);
    $dob = $conn->real_escape_string($_POST['dob']);
    $gender = $conn->real_escape_string($_POST['gender']);
    $address = $conn->real_escape_string($_POST['address']);
    $city = $conn->real_escape_string($_POST['city']);
    $country = $conn->real_escape_string($_POST['country']);

    // Upsert Personal Details
    if ($details) {
        $sql = "UPDATE personal_details SET 
                father_name='$father_name', dob='$dob', gender='$gender', 
                address='$address', city='$city', country='$country' 
                WHERE user_id=$user_id";
    } else {
        $sql = "INSERT INTO personal_details (user_id, father_name, dob, gender, address, city, country) 
                VALUES ($user_id, '$father_name', '$dob', '$gender', '$address', '$city', '$country')";
    }
    
    if ($conn->query($sql) === TRUE) {
        // Create draft application if not exists or update current session application
        // For simplicity, we just pass the program_id to the next step
        $_SESSION['current_application_program_id'] = $program_id;
        header("Location: application_academic.php");
        exit();
    } else {
        $message = "Error saving details: " . $conn->error;
    }
}
?>

<div class="dashboard-container">
    <div class="sidebar">
        <ul class="sidebar-menu">
            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt" style="margin-right: 10px;"></i> Dashboard</a></li>
            <li><a href="application.php" class="active"><i class="fas fa-edit" style="margin-right: 10px;"></i> New Application</a></li>
            <li><a href="profile.php"><i class="fas fa-user" style="margin-right: 10px;"></i> My Profile</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt" style="margin-right: 10px;"></i> Logout</a></li>
        </ul>
    </div>

    <div class="main-content">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Step 1: Program & Personal Details</h3>
            </div>
            
            <div style="margin-bottom: 20px;">
                <span class="badge badge-success">Step 1: Personal</span>
                <span class="badge badge-warning">Step 2: Academic</span>
                <span class="badge badge-warning">Step 3: Documents</span>
                <span class="badge badge-warning">Step 4: Review</span>
            </div>

            <?php if($message): ?>
                <div class="alert alert-danger"><?php echo $message; ?></div>
            <?php endif; ?>

            <form method="POST" action="">
                <h4 style="color: var(--primary-color); border-bottom: 1px solid #eee; padding-bottom: 10px; margin-bottom: 20px;">Select Program</h4>
                <div class="form-group">
                    <label>Choose Program to Apply</label>
                    <select name="program_id" class="form-control" required>
                        <option value="">-- Select Program --</option>
                        <?php
                        $prog_sql = "SELECT id, program_name, degree_level FROM programs WHERE is_active = 1";
                        $prog_res = $conn->query($prog_sql);
                        while($p = $prog_res->fetch_assoc()) {
                            $selected = (isset($_SESSION['current_application_program_id']) && $_SESSION['current_application_program_id'] == $p['id']) ? 'selected' : '';
                            echo "<option value='".$p['id']."' $selected>".$p['program_name']." (".$p['degree_level'].")</option>";
                        }
                        ?>
                    </select>
                </div>

                <h4 style="color: var(--primary-color); border-bottom: 1px solid #eee; padding-bottom: 10px; margin-bottom: 20px; margin-top: 30px;">Personal Information</h4>
                
                <div style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label>Father's Name</label>
                        <input type="text" name="father_name" class="form-control" value="<?php echo $details['father_name'] ?? ''; ?>" required>
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label>Date of Birth</label>
                        <input type="date" name="dob" class="form-control" value="<?php echo $details['dob'] ?? ''; ?>" required>
                    </div>
                </div>

                <div style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label>Gender</label>
                        <select name="gender" class="form-control" required>
                            <option value="">-- Select --</option>
                            <option value="Male" <?php echo (isset($details['gender']) && $details['gender'] == 'Male') ? 'selected' : ''; ?>>Male</option>
                            <option value="Female" <?php echo (isset($details['gender']) && $details['gender'] == 'Female') ? 'selected' : ''; ?>>Female</option>
                            <option value="Other" <?php echo (isset($details['gender']) && $details['gender'] == 'Other') ? 'selected' : ''; ?>>Other</option>
                        </select>
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label>City</label>
                        <input type="text" name="city" class="form-control" value="<?php echo $details['city'] ?? ''; ?>" required>
                    </div>
                </div>

                <div style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label>Country</label>
                        <input type="text" name="country" class="form-control" value="<?php echo $details['country'] ?? ''; ?>" required>
                    </div>
                </div>

                <div class="form-group">
                    <label>Address</label>
                    <textarea name="address" class="form-control" rows="3" required><?php echo $details['address'] ?? ''; ?></textarea>
                </div>

                <div style="text-align: right; margin-top: 20px;">
                    <button type="submit" class="btn-primary" style="padding: 10px 30px;">Next: Academic Records <i class="fas fa-arrow-right"></i></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
