<?php
include 'includes/db.php';
include 'includes/header.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['full_name'];

// Fetch user applications
$sql = "SELECT a.id, p.program_name, a.status, a.submission_date, a.payment_status 
        FROM applications a 
        JOIN programs p ON a.program_id = p.id 
        WHERE a.user_id = $user_id ORDER BY a.id DESC";
$result = $conn->query($sql);
?>

<div class="dashboard-container">
    <div class="sidebar">
        <div style="padding: 20px; text-align: center; border-bottom: 1px solid #eee;">
            <i class="fas fa-user-circle fa-4x" style="color: #ccc;"></i>
            <h4 style="margin-top: 10px; margin-bottom: 5px;"><?php echo $user_name; ?></h4>
            <span class="badge badge-info">Student</span>
        </div>
        <ul class="sidebar-menu">
            <li><a href="dashboard.php" class="active"><i class="fas fa-tachometer-alt" style="margin-right: 10px;"></i> Dashboard</a></li>
            <li><a href="application.php"><i class="fas fa-edit" style="margin-right: 10px;"></i> New Application</a></li>
            <li><a href="profile.php"><i class="fas fa-user" style="margin-right: 10px;"></i> My Profile</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt" style="margin-right: 10px;"></i> Logout</a></li>
        </ul>
    </div>

    <div class="main-content">
        <h2 style="margin-bottom: 25px;">My Applications</h2>

        <?php if ($result->num_rows > 0): ?>
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Application History</h3>
                    <a href="application.php" class="btn-primary" style="padding: 8px 15px; text-decoration: none; border-radius: 4px;">Apply New</a>
                </div>
                <table>
                    <thead>
                        <tr>
                            <th>App ID</th>
                            <th>Program</th>
                            <th>Submission Date</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($row = $result->fetch_assoc()): 
                            $status_class = 'badge-warning';
                            if($row['status'] == 'Submitted') $status_class = 'badge-info';
                            if($row['status'] == 'Accepted') $status_class = 'badge-success';
                            if($row['status'] == 'Rejected') $status_class = 'badge-danger';
                        ?>
                        <tr>
                            <td>#<?php echo $row['id']; ?></td>
                            <td><?php echo $row['program_name']; ?></td>
                            <td><?php echo $row['submission_date'] ? date('d M, Y', strtotime($row['submission_date'])) : 'Not Submitted'; ?></td>
                            <td>
                                <span class="badge <?php echo $status_class; ?>"><?php echo $row['status']; ?></span>
                                <?php if(($row['payment_status'] ?? '') == 'Paid'): ?>
                                    <br><span class="badge badge-success" style="font-size: 0.7rem; margin-top: 2px;">Paid</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="view_application.php?id=<?php echo $row['id']; ?>" style="color: var(--primary-color); margin-right: 10px;"><i class="fas fa-eye"></i> View</a>
                                <?php if($row['status'] == 'Submitted' || $row['status'] == 'Accepted'): ?>
                                    <a href="generate_challan.php?id=<?php echo $row['id']; ?>" target="_blank" style="color: var(--secondary-color); margin-right: 10px;"><i class="fas fa-file-invoice-dollar"></i> Challan</a>
                                    <?php 
                                        // Check payment status locally since we don't have it in $row yet (need to update query in dashboard.php)
                                        // Ideally we update the query. Let's assume we update query below.
                                     ?>
                                     <a href="payment.php?id=<?php echo $row['id']; ?>" style="color: green;"><i class="fas fa-credit-card"></i> Pay Online</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="card" style="text-align: center; padding: 50px;">
                <i class="fas fa-folder-open fa-3x" style="color: #ccc; margin-bottom: 20px;"></i>
                <h3>No Applications Found</h3>
                <p>You haven't applied to any program yet.</p>
                <a href="application.php" class="btn-primary" style="padding: 10px 20px; text-decoration: none; display: inline-block; margin-top: 20px;">Start New Application</a>
            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Instructions</h3>
            </div>
            <p>1. Please fill out all required fields in the application form carefully.</p>
            <p>2. Upload clear scanned copies of your documents.</p>
            <p>3. Once submitted, you cannot edit your application.</p>
            <p>4. Check your dashboard regularly for status updates.</p>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
