<?php
include 'includes/db.php';

echo "<h2>Checking Database Schema...</h2>";

// Check if columns exist
$result = $conn->query("SHOW COLUMNS FROM applications LIKE 'payment_status'");
if ($result->num_rows == 0) {
    echo "Adding payment columns...<br>";
    $sql = "ALTER TABLE applications 
            ADD COLUMN payment_status ENUM('Pending', 'Paid', 'Verification Pending') DEFAULT 'Pending', 
            ADD COLUMN payment_method VARCHAR(50), 
            ADD COLUMN transaction_id VARCHAR(100), 
            ADD COLUMN payment_date TIMESTAMP NULL";
    
    if ($conn->query($sql) === TRUE) {
        echo "<span style='color:green'>Success: Payment columns added.</span><br>";
    } else {
        echo "<span style='color:red'>Error: " . $conn->error . "</span><br>";
    }
} else {
    echo "<span style='color:blue'>Payment columns already exist.</span><br>";
}

echo "<br><a href='dashboard.php'>Go to Dashboard</a>";
?>
