<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$servername = "localhost";
$username = "root";
$password = "";
$dbname = "admission_system";

echo "Connecting to database...\n";
$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error . "\n");
}
echo "Connected successfully.\n";

// Add payment_status
echo "Attempting to add payment_status column...\n";
$sql = "ALTER TABLE applications ADD COLUMN payment_status ENUM('Pending', 'Paid', 'Verification Pending') DEFAULT 'Pending'";
try {
    if ($conn->query($sql) === TRUE) {
        echo "Column payment_status added successfully.\n";
    } else {
        echo "Error adding payment_status: " . $conn->error . "\n";
    }
} catch (Exception $e) {
    echo "Exception adding payment_status: " . $e->getMessage() . "\n";
}

// Add payment_method
echo "Attempting to add payment_method column...\n";
$sql = "ALTER TABLE applications ADD COLUMN payment_method VARCHAR(50)";
try {
    if ($conn->query($sql) === TRUE) {
        echo "Column payment_method added successfully.\n";
    } else {
        echo "Error adding payment_method: " . $conn->error . "\n";
    }
} catch (Exception $e) {
    echo "Exception adding payment_method: " . $e->getMessage() . "\n";
}

// Add transaction_id
echo "Attempting to add transaction_id column...\n";
$sql = "ALTER TABLE applications ADD COLUMN transaction_id VARCHAR(100)";
try {
    if ($conn->query($sql) === TRUE) {
        echo "Column transaction_id added successfully.\n";
    } else {
        echo "Error adding transaction_id: " . $conn->error . "\n";
    }
} catch (Exception $e) {
    echo "Exception adding transaction_id: " . $e->getMessage() . "\n";
}

// Add payment_date
echo "Attempting to add payment_date column...\n";
$sql = "ALTER TABLE applications ADD COLUMN payment_date TIMESTAMP NULL";
try {
    if ($conn->query($sql) === TRUE) {
        echo "Column payment_date added successfully.\n";
    } else {
        echo "Error adding payment_date: " . $conn->error . "\n";
    }
} catch (Exception $e) {
    echo "Exception adding payment_date: " . $e->getMessage() . "\n";
}

// Verify columns
echo "\nVerifying columns in 'applications' table:\n";
$result = $conn->query("SHOW COLUMNS FROM applications");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        echo "- " . $row['Field'] . "\n";
    }
}

$conn->close();
?>
