<?php
include 'includes/db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$user_role = isset($_SESSION['role']) ? $_SESSION['role'] : 'student';
$app_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch Application & Program
$sql = "SELECT a.id, a.submission_date, p.program_name, p.fee_per_semester, u.full_name, u.cnic, u.phone 
        FROM applications a 
        JOIN programs p ON a.program_id = p.id 
        JOIN users u ON a.user_id = u.id 
        WHERE a.id = $app_id";

// If not admin, restrict to own application
if ($user_role != 'admin') {
    $sql .= " AND a.user_id = $user_id";
}

$result = $conn->query($sql);

if ($result->num_rows == 0) {
    die("Application not found or access denied.");
}

$data = $result->fetch_assoc();
$challan_no = "CH-" . str_pad($data['id'], 6, '0', STR_PAD_LEFT);
$due_date = date('d M, Y', strtotime('+10 days'));

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Fee Challan - <?php echo $challan_no; ?></title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; margin: 20px; }
        .container { display: flex; gap: 20px; }
        .challan-box { flex: 1; border: 1px solid #000; padding: 10px; }
        .header { text-align: center; border-bottom: 1px solid #000; padding-bottom: 5px; margin-bottom: 10px; }
        .logo { font-weight: bold; font-size: 16px; margin-bottom: 5px; }
        .copy-type { font-style: italic; font-size: 10px; float: right; }
        .row { display: flex; justify-content: space-between; margin-bottom: 5px; }
        .table { width: 100%; border-collapse: collapse; margin-top: 10px; margin-bottom: 10px; }
        .table th, .table td { border: 1px solid #000; padding: 5px; text-align: left; }
        .total { text-align: right; font-weight: bold; margin-top: 10px; }
        .footer { margin-top: 30px; font-size: 10px; }
        @media print {
            .no-print { display: none; }
            .container { gap: 10px; }
        }
    </style>
</head>
<body>
    <div class="no-print" style="margin-bottom: 20px; text-align: center;">
        <button onclick="window.print()" style="padding: 10px 20px; background: #004d40; color: #fff; border: none; cursor: pointer;">Print Challan</button>
        <a href="dashboard.php" style="margin-left: 10px; text-decoration: none; color: #333;">Back to Dashboard</a>
    </div>

    <div class="container">
        <!-- Bank Copy -->
        <?php for($i=1; $i<=3; $i++): 
            $type = ($i==1) ? "Bank Copy" : (($i==2) ? "Office Copy" : "Student Copy");
        ?>
        <div class="challan-box">
            <div class="header">
                <span class="copy-type"><?php echo $type; ?></span>
                <div class="logo">University of Lahore</div>
                <div>Admission Processing Fee</div>
            </div>
            <div class="row"><strong>Challan No:</strong> <?php echo $challan_no; ?></div>
            <div class="row"><strong>Date:</strong> <?php echo date('d M, Y'); ?></div>
            <div class="row"><strong>Due Date:</strong> <?php echo $due_date; ?></div>
            <hr>
            <div class="row"><strong>Name:</strong> <?php echo $data['full_name']; ?></div>
            <div class="row"><strong>CNIC:</strong> <?php echo $data['cnic']; ?></div>
            <div class="row"><strong>Program:</strong> <?php echo $data['program_name']; ?></div>
            
            <table class="table">
                <tr>
                    <th>Description</th>
                    <th>Amount (PKR)</th>
                </tr>
                <tr>
                    <td>Prospectus & Processing Fee</td>
                    <td>2,000</td>
                </tr>
                <tr>
                    <td><strong>Total</strong></td>
                    <td><strong>2,000</strong></td>
                </tr>
            </table>
            
            <div style="margin-top: 20px; font-size: 10px;">
                <strong>Amount in Words:</strong> Two Thousand Rupees Only.
            </div>

            <div class="footer">
                <div style="float: left; border-top: 1px solid #000; padding-top: 5px; width: 40%;">Bank Officer</div>
                <div style="float: right; border-top: 1px solid #000; padding-top: 5px; width: 40%; text-align: right;">Depositor</div>
                <div style="clear: both;"></div>
            </div>
            <div style="margin-top: 10px; font-size: 9px; text-align: center;">
                Valid at any designated bank branch.
                <?php
                $bank_sql = "SELECT bank_name, account_number FROM payment_options WHERE is_active = 1";
                $bank_res = $conn->query($bank_sql);
                if ($bank_res->num_rows > 0) {
                    echo "<br><strong>Available Banks:</strong> ";
                    $banks = [];
                    while($b = $bank_res->fetch_assoc()) {
                        $banks[] = $b['bank_name'] . " (" . $b['account_number'] . ")";
                    }
                    echo implode(", ", $banks);
                }
                ?>
            </div>
        </div>
        <?php endfor; ?>
    </div>
</body>
</html>
