<?php 
include 'includes/db.php';
include 'includes/header.php'; 

// Fetch System Settings
$current_session = 'Fall';
$current_academic_year = date('Y');
$res = $conn->query("SELECT setting_key, setting_value FROM system_settings");
if ($res->num_rows > 0) {
    while($row = $res->fetch_assoc()) {
        if($row['setting_key'] == 'current_session') $current_session = $row['setting_value'];
        if($row['setting_key'] == 'current_academic_year') $current_academic_year = $row['setting_value'];
    }
}
?>

<div class="hero">
    <div class="container">
        <h1>Welcome to University Admission Portal</h1>
        <p>Your future starts here. Apply now for <?php echo $current_session . ' ' . $current_academic_year; ?> Admissions.</p>
        <a href="register.php" class="btn-primary" style="padding: 15px 30px; font-size: 1.1rem; display: inline-block;">Apply Online</a>
    </div>
</div>

<div class="container" style="padding: 60px 15px;">
    <h2 class="text-center" style="margin-bottom: 50px; color: var(--primary-color);">How to Apply</h2>
    
    <div style="display: flex; flex-wrap: wrap; justify-content: space-between; gap: 30px;">
        <div style="flex: 1; min-width: 300px; text-align: center; padding: 30px; background: #fff; box-shadow: 0 5px 15px rgba(0,0,0,0.05); border-radius: 8px;">
            <i class="fas fa-user-plus fa-3x" style="color: var(--secondary-color); margin-bottom: 20px;"></i>
            <h3>1. Create Account</h3>
            <p>Register yourself by providing basic details and verify your email/phone.</p>
        </div>
        
        <div style="flex: 1; min-width: 300px; text-align: center; padding: 30px; background: #fff; box-shadow: 0 5px 15px rgba(0,0,0,0.05); border-radius: 8px;">
            <i class="fas fa-file-alt fa-3x" style="color: var(--secondary-color); margin-bottom: 20px;"></i>
            <h3>2. Fill Application</h3>
            <p>Complete your personal information, academic record, and upload documents.</p>
        </div>
        
        <div style="flex: 1; min-width: 300px; text-align: center; padding: 30px; background: #fff; box-shadow: 0 5px 15px rgba(0,0,0,0.05); border-radius: 8px;">
            <i class="fas fa-check-circle fa-3x" style="color: var(--secondary-color); margin-bottom: 20px;"></i>
            <h3>3. Submit & Track</h3>
            <p>Submit your application and track its status through your dashboard.</p>
        </div>
    </div>
</div>

<div style="background-color: #e0f2f1; padding: 60px 0;">
    <div class="container">
        <h2 class="text-center" style="margin-bottom: 40px; color: var(--primary-color);">Important Dates</h2>
        <table style="background: #fff; box-shadow: 0 2px 10px rgba(0,0,0,0.05);">
            <tr>
                <th>Event</th>
                <th>Date</th>
            </tr>
            <tr>
                <td>Admissions Open</td>
                <td>December 1, 2025</td>
            </tr>
            <tr>
                <td>Last Date to Apply</td>
                <td>January 15, 2026</td>
            </tr>
            <tr>
                <td>Entry Test</td>
                <td>January 20, 2026</td>
            </tr>
            <tr>
                <td>Merit List Display</td>
                <td>February 1, 2026</td>
            </tr>
        </table>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
