<?php
include 'includes/db.php';
include 'includes/header.php';

// Fetch Programs for Filter
$prog_sql = "SELECT id, program_name FROM programs WHERE is_active = 1";
$prog_result = $conn->query($prog_sql);

$selected_program = isset($_GET['program']) ? intval($_GET['program']) : 0;
?>

<div class="container" style="padding: 40px 15px;">
    <h1 class="text-center" style="margin-bottom: 40px; color: var(--primary-color);">Merit Lists - Fall 2025</h1>

    <div class="card" style="max-width: 800px; margin: 0 auto 40px;">
        <form method="GET" action="" style="display: flex; gap: 10px; padding: 20px; align-items: center; justify-content: center;">
            <label style="font-weight: bold;">Select Program:</label>
            <select name="program" class="form-control" style="width: auto; flex: 1; max-width: 400px;" onchange="this.form.submit()">
                <option value="">-- All Programs --</option>
                <?php while($p = $prog_result->fetch_assoc()): ?>
                    <option value="<?php echo $p['id']; ?>" <?php if($selected_program == $p['id']) echo 'selected'; ?>>
                        <?php echo $p['program_name']; ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </form>
    </div>

    <?php
    $where_clause = "WHERE a.status = 'Accepted'";
    if ($selected_program > 0) {
        $where_clause .= " AND a.program_id = $selected_program";
    }

    $sql = "SELECT a.id, u.full_name, p.program_name, p.degree_level 
            FROM applications a 
            JOIN users u ON a.user_id = u.id 
            JOIN programs p ON a.program_id = p.id 
            $where_clause 
            ORDER BY p.program_name, u.full_name";
    
    $result = $conn->query($sql);
    ?>

    <?php if ($result->num_rows > 0): ?>
        <div class="card">
            <table>
                <thead>
                    <tr>
                        <th>App ID</th>
                        <th>Student Name</th>
                        <th>Program</th>
                        <th>Level</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $row['id']; ?></td>
                        <td><?php echo $row['full_name']; ?></td>
                        <td><?php echo $row['program_name']; ?></td>
                        <td><?php echo $row['degree_level']; ?></td>
                        <td><span class="badge badge-success">Admitted</span></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="text-center" style="padding: 40px; background: #fff; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.05);">
            <i class="fas fa-list-alt fa-3x" style="color: #ccc; margin-bottom: 20px;"></i>
            <h3>No Records Found</h3>
            <p>The merit list for the selected criteria has not been displayed yet.</p>
        </div>
    <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>
