<?php
include 'includes/db.php';
include 'includes/header.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$app_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$user_id = $_SESSION['user_id'];

// Fetch Application Details
$sql = "SELECT a.*, p.program_name, p.fee_per_semester 
        FROM applications a 
        JOIN programs p ON a.program_id = p.id 
        WHERE a.id = $app_id AND a.user_id = $user_id";
$result = $conn->query($sql);

if ($result->num_rows == 0) {
    echo "<div class='container' style='padding: 50px;'><div class='alert alert-danger'>Application not found.</div></div>";
    include 'includes/footer.php';
    exit();
}

$app = $result->fetch_assoc();
$fee_amount = 2000; // Fixed Admission Processing Fee as per Challan
// Or use $app['fee_per_semester'] if paying semester fee. 
// Usually admission processing fee is separate. Let's stick to 2000 as per challan example.

$message = "";
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $method = $_POST['payment_method'];
    $trx_id = "TRX-" . strtoupper(uniqid()); // Simulated Transaction ID
    
    // Simulate API Call / Processing
    $sql_update = "UPDATE applications SET 
                   payment_status = 'Paid', 
                   payment_method = '$method', 
                   transaction_id = '$trx_id', 
                   payment_date = NOW() 
                   WHERE id = $app_id";
    
    if ($conn->query($sql_update) === TRUE) {
        $message = "Payment successful! Transaction ID: $trx_id";
        $app['payment_status'] = 'Paid'; // Update local var for display
    } else {
        $message = "Error processing payment: " . $conn->error;
    }
}
?>

<div class="dashboard-container">
    <div class="sidebar">
        <ul class="sidebar-menu">
            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt" style="margin-right: 10px;"></i> Dashboard</a></li>
            <li><a href="application.php"><i class="fas fa-edit" style="margin-right: 10px;"></i> New Application</a></li>
            <li><a href="profile.php"><i class="fas fa-user" style="margin-right: 10px;"></i> My Profile</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt" style="margin-right: 10px;"></i> Logout</a></li>
        </ul>
    </div>

    <div class="main-content">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Pay Admission Fee</h3>
                <a href="dashboard.php" class="btn-outline" style="padding: 5px 15px; text-decoration: none;">Back</a>
            </div>

            <?php if($message): ?>
                <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>

            <div style="margin-bottom: 30px; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                <h4 style="margin-top: 0;">Application Summary</h4>
                <p><strong>Program:</strong> <?php echo $app['program_name']; ?></p>
                <p><strong>Application ID:</strong> #<?php echo $app['id']; ?></p>
                <p><strong>Amount Payable:</strong> <span style="font-size: 1.2rem; color: var(--primary-color); font-weight: bold;">PKR <?php echo number_format($fee_amount); ?></span></p>
                <p><strong>Status:</strong> 
                    <?php if($app['payment_status'] == 'Paid'): ?>
                        <span class="badge badge-success">Paid</span>
                    <?php else: ?>
                        <span class="badge badge-warning">Pending</span>
                    <?php endif; ?>
                </p>
            </div>

            <?php if($app['payment_status'] != 'Paid'): ?>
            <h3 style="margin-bottom: 20px;">Select Payment Method</h3>
            
            <div class="payment-methods" style="display: flex; gap: 20px; margin-bottom: 30px;">
                <button onclick="selectMethod('jazzcash')" id="btn-jazzcash" class="btn-outline" style="flex: 1; padding: 20px; text-align: center; border-width: 2px;">
                    <i class="fas fa-mobile-alt fa-2x"></i><br>JazzCash
                </button>
                <button onclick="selectMethod('easypaisa')" id="btn-easypaisa" class="btn-outline" style="flex: 1; padding: 20px; text-align: center; border-width: 2px;">
                    <i class="fas fa-mobile-alt fa-2x"></i><br>EasyPaisa
                </button>
                <button onclick="selectMethod('bank')" id="btn-bank" class="btn-outline" style="flex: 1; padding: 20px; text-align: center; border-width: 2px;">
                    <i class="fas fa-university fa-2x"></i><br>Bank Transfer
                </button>
                <button onclick="selectMethod('paypal')" id="btn-paypal" class="btn-outline" style="flex: 1; padding: 20px; text-align: center; border-width: 2px;">
                    <i class="fab fa-paypal fa-2x"></i><br>PayPal
                </button>
            </div>

            <div id="payment-form-container" style="display: none; border: 1px solid #ddd; padding: 20px; border-radius: 8px;">
                <h4 id="selected-method-title" style="margin-top: 0; color: var(--primary-color);">Enter Details</h4>
                <form method="POST" action="">
                    <input type="hidden" name="payment_method" id="input_payment_method">
                    
                    <div id="mobile-fields" style="display: none;">
                        <div class="form-group">
                            <label>Mobile Number</label>
                            <input type="text" class="form-control" placeholder="03XX-XXXXXXX" required>
                        </div>
                    </div>

                    <div id="bank-fields" style="display: none;">
                        <div class="alert alert-info">Please transfer PKR <?php echo number_format($fee_amount); ?> to Account: <strong>0123-456789-001</strong> (HBL) and enter Reference ID.</div>
                        <div class="form-group">
                            <label>Sender Account Title</label>
                            <input type="text" class="form-control">
                        </div>
                    </div>

                    <div id="paypal-fields" style="display: none;">
                        <div class="form-group">
                            <label>PayPal Email</label>
                            <input type="email" class="form-control">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>PIN / Reference ID (Simulated)</label>
                        <input type="password" class="form-control" placeholder="Enter PIN to confirm" required>
                    </div>

                    <button type="submit" class="btn-primary" style="width: 100%; padding: 12px; font-size: 1.1rem;">Pay Now</button>
                </form>
            </div>

            <script>
                function selectMethod(method) {
                    // Reset buttons
                    document.querySelectorAll('.payment-methods button').forEach(btn => {
                        btn.style.backgroundColor = 'transparent';
                        btn.style.color = 'var(--primary-color)';
                        btn.style.borderColor = 'var(--primary-color)';
                    });
                    
                    // Highlight selected
                    const btn = document.getElementById('btn-' + method);
                    btn.style.backgroundColor = 'var(--primary-color)';
                    btn.style.color = '#fff';

                    // Show form
                    document.getElementById('payment-form-container').style.display = 'block';
                    document.getElementById('input_payment_method').value = method;
                    
                    // Toggle fields
                    document.getElementById('mobile-fields').style.display = 'none';
                    document.getElementById('bank-fields').style.display = 'none';
                    document.getElementById('paypal-fields').style.display = 'none';

                    let title = "";
                    if(method === 'jazzcash') { title = "JazzCash Payment"; document.getElementById('mobile-fields').style.display = 'block'; }
                    if(method === 'easypaisa') { title = "EasyPaisa Payment"; document.getElementById('mobile-fields').style.display = 'block'; }
                    if(method === 'bank') { title = "Bank Transfer Verification"; document.getElementById('bank-fields').style.display = 'block'; }
                    if(method === 'paypal') { title = "PayPal Payment"; document.getElementById('paypal-fields').style.display = 'block'; }
                    
                    document.getElementById('selected-method-title').innerText = title;
                }
            </script>
            <?php else: ?>
                <div style="text-align: center; padding: 40px;">
                    <i class="fas fa-check-circle fa-5x" style="color: green; margin-bottom: 20px;"></i>
                    <h3>Fee Paid Successfully</h3>
                    <p>Transaction ID: <?php echo $app['transaction_id']; ?></p>
                    <p>Date: <?php echo date('d M, Y h:i A', strtotime($app['payment_date'])); ?></p>
                    <button onclick="window.print()" class="btn-primary"><i class="fas fa-print"></i> Print Receipt</button>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
