<?php 
include 'includes/db.php';
include 'includes/header.php'; 
?>

<div class="container" style="padding: 40px 15px;">
    <h1 class="text-center" style="margin-bottom: 40px; color: var(--primary-color);">Our Programs</h1>

    <!-- Search and Filter Form -->
    <div style="background: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 40px; border: 1px solid #ddd;">
        <form method="GET" action="" style="display: flex; gap: 15px; flex-wrap: wrap;">
            <div style="flex: 2; min-width: 200px;">
                <input type="text" name="search" class="form-control" placeholder="Search Program Name..." value="<?php echo isset($_GET['search']) ? htmlspecialchars($_GET['search']) : ''; ?>" style="width: 100%; padding: 10px;">
            </div>
            <div style="flex: 1; min-width: 150px;">
                <select name="department" class="form-control" style="width: 100%; padding: 10px;">
                    <option value="">All Departments</option>
                    <?php
                    $dept_sql = "SELECT DISTINCT department FROM programs WHERE is_active = 1 ORDER BY department";
                    $dept_res = $conn->query($dept_sql);
                    while($d = $dept_res->fetch_assoc()) {
                        $selected = (isset($_GET['department']) && $_GET['department'] == $d['department']) ? 'selected' : '';
                        echo "<option value='".$d['department']."' $selected>".$d['department']."</option>";
                    }
                    ?>
                </select>
            </div>
            <div style="flex: 1; min-width: 150px;">
                <select name="level" class="form-control" style="width: 100%; padding: 10px;">
                    <option value="">All Levels</option>
                    <option value="Bachelor" <?php echo (isset($_GET['level']) && $_GET['level'] == 'Bachelor') ? 'selected' : ''; ?>>Bachelor</option>
                    <option value="Master" <?php echo (isset($_GET['level']) && $_GET['level'] == 'Master') ? 'selected' : ''; ?>>Master</option>
                    <option value="PhD" <?php echo (isset($_GET['level']) && $_GET['level'] == 'PhD') ? 'selected' : ''; ?>>PhD</option>
                    <option value="Diploma" <?php echo (isset($_GET['level']) && $_GET['level'] == 'Diploma') ? 'selected' : ''; ?>>Diploma</option>
                </select>
            </div>
            <button type="submit" class="btn-primary" style="padding: 10px 25px;">Search</button>
            <?php if(isset($_GET['search']) || isset($_GET['department']) || isset($_GET['level'])): ?>
                <a href="programs.php" class="btn-outline" style="text-decoration: none; padding: 10px 20px; display: inline-block;">Clear</a>
            <?php endif; ?>
        </form>
    </div>

    <?php
    $where_clause = "WHERE is_active = 1";
    
    if (isset($_GET['search']) && !empty($_GET['search'])) {
        $search = $conn->real_escape_string($_GET['search']);
        $where_clause .= " AND program_name LIKE '%$search%'";
    }

    if (isset($_GET['department']) && !empty($_GET['department'])) {
        $dept_filter = $conn->real_escape_string($_GET['department']);
        $where_clause .= " AND department = '$dept_filter'";
    }

    if (isset($_GET['level']) && !empty($_GET['level'])) {
        $level_filter = $conn->real_escape_string($_GET['level']);
        $where_clause .= " AND degree_level = '$level_filter'";
    }

    // Get distinct departments from the filtered results
    $departments_sql = "SELECT DISTINCT department FROM programs $where_clause ORDER BY department";
    $dept_result = $conn->query($departments_sql);

    if ($dept_result && $dept_result->num_rows > 0) {
        while($dept_row = $dept_result->fetch_assoc()) {
            $department = $dept_row['department'];
            echo "<h2 style='border-bottom: 2px solid var(--secondary-color); padding-bottom: 10px; margin-top: 40px;'>$department</h2>";
            
            echo "<div style='display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px; margin-top: 20px;'>";
            
            $prog_sql = "SELECT * FROM programs $where_clause AND department = '" . $conn->real_escape_string($department) . "'";
            $prog_result = $conn->query($prog_sql);
            
            while($prog = $prog_result->fetch_assoc()) {
                ?>
                <div class="card" style="border-left: 5px solid var(--primary-color);">
                    <h3 style="margin-top: 0;"><?php echo $prog['program_name']; ?></h3>
                    <p><strong>Level:</strong> <span class="badge badge-info"><?php echo $prog['degree_level']; ?></span></p>
                    <p><strong>Duration:</strong> <?php echo $prog['duration']; ?></p>
                    <p><strong>Fee (Per Semester):</strong> PKR <?php echo number_format($prog['fee_per_semester']); ?></p>
                    <?php if(!empty($prog['admission_criteria'])): ?>
                        <div style="margin-top: 10px; padding: 10px; background: #f9f9f9; border-radius: 4px; font-size: 0.9rem;">
                            <strong>Admission Criteria:</strong><br>
                            <?php echo nl2br(htmlspecialchars($prog['admission_criteria'])); ?>
                        </div>
                    <?php endif; ?>
                    <div style="margin-top: 15px;">
                        <a href="register.php" class="btn-primary" style="padding: 8px 15px; font-size: 0.9rem; text-decoration: none; display: inline-block;">Apply Now</a>
                    </div>
                </div>
                <?php
            }
            echo "</div>";
        }
    } else {
        echo "<p class='text-center'>No programs found matching your criteria.</p>";
    }
    ?>
</div>

<?php include 'includes/footer.php'; ?>
