<?php 
include 'includes/db.php';
include 'includes/header.php'; 

$error = '';
$success = '';

// Check Registration Status
$reg_status = 'open';
$current_year = date('Y');
$settings_sql = "SELECT setting_key, setting_value FROM system_settings";
$settings_res = $conn->query($settings_sql);
if ($settings_res && $settings_res->num_rows > 0) {
    while($row = $settings_res->fetch_assoc()) {
        if($row['setting_key'] == 'registration_status') $reg_status = $row['setting_value'];
        if($row['setting_key'] == 'current_academic_year') $current_year = $row['setting_value'];
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if ($reg_status == 'closed') {
        $error = "Registration is currently closed.";
    } else {
        $full_name = $conn->real_escape_string($_POST['full_name']);
    $email = $conn->real_escape_string($_POST['email']);
    $cnic = $conn->real_escape_string($_POST['cnic']);
    $phone = $conn->real_escape_string($_POST['phone']);
    $session = $conn->real_escape_string($_POST['session']);
    $academic_year = $conn->real_escape_string($_POST['academic_year']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    if ($password !== $confirm_password) {
        $error = "Passwords do not match.";
    } else {
        // Check if user already exists
        $check_sql = "SELECT id FROM users WHERE email = '$email' OR cnic = '$cnic'";
        $result = $conn->query($check_sql);
        
        if ($result->num_rows > 0) {
            $error = "User with this Email or CNIC already exists.";
        } else {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $sql = "INSERT INTO users (full_name, email, cnic, phone, session, academic_year, password) VALUES ('$full_name', '$email', '$cnic', '$phone', '$session', '$academic_year', '$hashed_password')";
            
            if ($conn->query($sql) === TRUE) {
                $success = "Registration successful! You can now <a href='login.php'>Login</a>.";
            } else {
                $error = "Error: " . $sql . "<br>" . $conn->error;
            }
        }
        }
    }
}
?>

<div class="auth-wrapper">
    <div class="auth-box">
        <h2>Create Account</h2>
        <?php if($error): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>
        <?php if($success): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <?php if($reg_status == 'closed'): ?>
            <div style="text-align: center; padding: 20px;">
                <i class="fas fa-exclamation-circle fa-3x" style="color: #d32f2f; margin-bottom: 15px;"></i>
                <h3 style="color: #d32f2f;">Admissions Closed</h3>
                <p>New student registrations are currently closed for this session.</p>
                <p>Please check back later or contact the administration.</p>
                <a href="index.php" class="btn-primary" style="display: inline-block; margin-top: 10px; text-decoration: none;">Back to Home</a>
            </div>
        <?php else: ?>
        
        <form method="POST" action="">
            <div class="form-group">
                <label>Full Name</label>
                <input type="text" name="full_name" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Email Address</label>
                <input type="email" name="email" class="form-control" required>
            </div>
            <div class="form-group">
                <label>CNIC (without dashes)</label>
                <input type="text" name="cnic" class="form-control" placeholder="3520212345671" required>
            </div>
            <div class="form-group">
                <label>Phone Number</label>
                <input type="text" name="phone" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Session</label>
                <select name="session" class="form-control" required>
                    <option value="Fall">Fall</option>
                    <option value="Spring">Spring</option>
                </select>
            </div>
            <div class="form-group">
                <label>Academic Year</label>
                <input type="text" name="academic_year" class="form-control" value="<?php echo $current_year; ?>" readonly style="background-color: #e9ecef;">
            </div>
            <div class="form-group">
                <label>Password</label>
                <input type="password" name="password" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Confirm Password</label>
                <input type="password" name="confirm_password" class="form-control" required>
            </div>
            <button type="submit" class="btn-primary btn-block">Register</button>
        </form>
        <p class="text-center" style="margin-top: 15px;">
            Already have an account? <a href="login.php">Login here</a>
        </p>
    <?php endif; ?>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
