<?php
include 'includes/db.php';
include 'includes/header.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$app_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch Application Details
$sql = "SELECT a.*, p.program_name, p.degree_level 
        FROM applications a 
        JOIN programs p ON a.program_id = p.id 
        WHERE a.id = $app_id AND a.user_id = $user_id";
$result = $conn->query($sql);

if ($result->num_rows == 0) {
    echo "<div class='container' style='padding: 50px;'><div class='alert alert-danger'>Application not found or access denied.</div></div>";
    include 'includes/footer.php';
    exit();
}

$application = $result->fetch_assoc();

// Fetch Personal Details
$sql_personal = "SELECT * FROM personal_details WHERE user_id = $user_id";
$res_personal = $conn->query($sql_personal);
$personal = $res_personal->fetch_assoc();

// Fetch Academic Records
$sql_academic = "SELECT * FROM academic_records WHERE user_id = $user_id";
$res_academic = $conn->query($sql_academic);

// Fetch Documents
$sql_docs = "SELECT * FROM documents WHERE user_id = $user_id";
$res_docs = $conn->query($sql_docs);
?>

<div class="dashboard-container">
    <div class="sidebar">
        <ul class="sidebar-menu">
            <li><a href="dashboard.php" class="active"><i class="fas fa-tachometer-alt" style="margin-right: 10px;"></i> Dashboard</a></li>
            <li><a href="application.php"><i class="fas fa-edit" style="margin-right: 10px;"></i> New Application</a></li>
            <li><a href="profile.php"><i class="fas fa-user" style="margin-right: 10px;"></i> My Profile</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt" style="margin-right: 10px;"></i> Logout</a></li>
        </ul>
    </div>

    <div class="main-content">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Application #<?php echo $application['id']; ?> Details</h3>
                <a href="dashboard.php" class="btn-outline" style="padding: 5px 15px; text-decoration: none;">Back to Dashboard</a>
            </div>
            
            <div style="background: #f8f9fa; padding: 15px; border-left: 4px solid var(--primary-color); margin-bottom: 20px;">
                <strong>Status:</strong> <?php echo $application['status']; ?> <br>
                <strong>Submission Date:</strong> <?php echo date('d M, Y h:i A', strtotime($application['submission_date'])); ?>
                <?php if(isset($application['payment_status'])): ?>
                    <br><strong>Payment Status:</strong> 
                    <?php 
                        $pay_color = 'red';
                        if($application['payment_status'] == 'Paid') $pay_color = 'green';
                        if($application['payment_status'] == 'Verification Pending') $pay_color = 'orange';
                    ?>
                    <span style="color: <?php echo $pay_color; ?>; font-weight: bold;"><?php echo $application['payment_status']; ?></span>
                    
                    <?php if(!empty($application['payment_receipt'])): ?>
                        <br><br>
                        <strong>Uploaded Receipt:</strong> 
                        <a href="<?php echo $application['payment_receipt']; ?>" target="_blank" style="margin-left: 5px; color: var(--primary-color);">
                            <i class="fas fa-file-invoice"></i> View Receipt
                        </a>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            <div style="margin-bottom: 30px;">
                <h3 style="color: var(--primary-color); border-bottom: 2px solid #eee; padding-bottom: 10px;">Program Information</h3>
                <p><strong>Program Name:</strong> <?php echo $application['program_name']; ?></p>
                <p><strong>Degree Level:</strong> <?php echo $application['degree_level']; ?></p>
            </div>

            <div style="margin-bottom: 30px;">
                <h3 style="color: var(--primary-color); border-bottom: 2px solid #eee; padding-bottom: 10px;">Personal Details</h3>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <p><strong>Full Name:</strong> <?php echo $_SESSION['full_name']; ?></p>
                    <p><strong>Father's Name:</strong> <?php echo $personal['father_name']; ?></p>
                    <p><strong>Date of Birth:</strong> <?php echo $personal['dob']; ?></p>
                    <p><strong>Gender:</strong> <?php echo $personal['gender']; ?></p>
                    <p><strong>City:</strong> <?php echo $personal['city']; ?></p>
                    <p><strong>Country:</strong> <?php echo $personal['country']; ?></p>
                    <p><strong>Address:</strong> <?php echo $personal['address']; ?></p>
                </div>
            </div>

            <div style="margin-bottom: 30px;">
                <h3 style="color: var(--primary-color); border-bottom: 2px solid #eee; padding-bottom: 10px;">Academic Records</h3>
                <table>
                    <thead>
                        <tr>
                            <th>Degree</th>
                            <th>Institute</th>
                            <th>Year</th>
                            <th>Marks</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($row = $res_academic->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $row['degree_title']; ?></td>
                            <td><?php echo $row['institute']; ?></td>
                            <td><?php echo $row['passing_year']; ?></td>
                            <td><?php echo $row['obtained_marks']; ?> / <?php echo $row['total_marks']; ?></td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>

            <div style="margin-bottom: 30px;">
                <h3 style="color: var(--primary-color); border-bottom: 2px solid #eee; padding-bottom: 10px;">Uploaded Documents</h3>
                <ul>
                    <?php while($row = $res_docs->fetch_assoc()): ?>
                        <li>
                            <?php echo $row['document_type']; ?> 
                            <a href="<?php echo $row['file_path']; ?>" target="_blank" style="margin-left: 10px; font-size: 0.9rem;">View File</a>
                        </li>
                    <?php endwhile; ?>
                </ul>
            </div>
            
            <div style="text-align: center; margin-top: 30px;">
                <button onclick="window.print()" class="btn-primary" style="padding: 10px 20px;"><i class="fas fa-print"></i> Print Application</button>
                <?php if($application['status'] == 'Submitted' || $application['status'] == 'Accepted'): ?>
                    <a href="generate_challan.php?id=<?php echo $application['id']; ?>" target="_blank" class="btn-primary" style="padding: 12px 20px; background-color: var(--secondary-color); margin-left: 10px; text-decoration: none; display: inline-block; border: none; font-size: 13.3333px; cursor: pointer;"><i class="fas fa-file-invoice-dollar"></i> Download Fee Challan</a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
